@extends('layouts/app')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css') }}">
<link rel="stylesheet" href="{{asset('assets/plugins/select2/css/select2.min.css') }}">
<link rel="stylesheet" href="{{asset('assets/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
@endsection

@section('template_title')
Users
@endsection

@section('content')
<div class="content">
    <div class="container-fluit">
        <div class="row">
            <div class="col-12">

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Edit Data</h3>
                        <div class="float-right">
                            @foreach ($data as $row)
                            <button type="button" class="btn btn-sm reset-password-button" data-customer-id="{{ $row->id }}" data-toggle="modal" data-target="#resetPasswordModal">
                                Reset Password
                            </button>
                            @endforeach
                        </div>
                    </div>
                    @foreach ($data as $row)
                    <form method="POST" onsubmit="return validasiinput();" role="form" enctype="multipart/form-data" action="{{ url('/users/' . $row->id) }}">
                        @csrf
                        <input type="hidden" name="_method" value="put">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Username<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <input type="text" class="form-control {{$errors->has('username') ? ' is-invalid' : ''}}" value="{{ $row->username }}" name="username" required autofocus>
                                        {!! $errors->first('username', '<div class="invalid-feedback">:message</div>') !!}

                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Nama<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <input type="text" class="form-control {{$errors->has('nama') ? ' is-invalid' : ''}}" value="{{ $row->name }}" name="nama" required>
                                        {!! $errors->first('nama', '<div class="invalid-feedback">:message</div>') !!}

                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Email<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <input type="email" class="form-control {{$errors->has('email') ? ' is-invalid' : ''}}" value="{{ $row->email }}" name="email" required>
                                        {!! $errors->first('email', '<div class="invalid-feedback">:message</div>') !!}

                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Level<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <select name="level" class="form-control {{$errors->has('level') ? ' is-invalid' : ''}} select2bs4">
                                            @foreach ($roles as $row_roles)
                                            <option value="{{ $row_roles->id }}-{{ $row_roles->name }}" @if ($row_roles->id == $row->level) selected @endif>
                                                {{ $row_roles->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                        {!! $errors->first('level', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="reset" onclick="history.go(-1)" class="btn btn-danger">Cancel</button>
                            <button type="submit" class="btn btn-primary float-right">Save</button>
                        </div>
                    </form>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="resetPasswordModal" tabindex="-1" role="dialog" aria-labelledby="updateCustomerModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="updateCustomerModalLabel">Edit User</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="get" action="{{ route('users.reset-password') }}">
                <div class="modal-body">
                    <div class="form-group row ml-1">
                        <p for="password" class="mr-1">Password Baru Anda: </p>
                        <label id="newPassword"></label>
                        <input type="password" class="form-control col-md-5" id="newPassword2" name="password" hidden>

                    </div>
                    @foreach ($data as $row)
                    <input type="hidden" value="{{$row->id}}" name="id">
                    @endforeach
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="{{ asset('assets/plugins/sweetalert2/sweetalert2.min.js') }}"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script src="{{ asset('assets/plugins/sweetalert2/sweetalert2.min.js') }}"></script>
<script src="{{ asset('assets/plugins/select2/js/select2.full.min.js') }}"></script>
<script>
    $(function() {
        //Initialize Select2 Elements
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })
    })
</script>

<script>
    // Fungsi untuk menghasilkan kata sandi acak
    function generateRandomPassword() {
        const length = 12; // Panjang kata sandi
        const charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"; // Karakter yang diizinkan
        let password = "";

        for (let i = 0; i < length; i++) {
            const randomIndex = Math.floor(Math.random() * charset.length);
            password += charset[randomIndex];
        }

        return password;
    }
    // Fungsi untuk menampilkan/menyembunyikan kata sandi
    function togglePasswordVisibility() {
        const passwordField = document.getElementById("newPassword");
        const eyeIcon = document.getElementById("eyeIcon");
        const confirmpasswordField = document.getElementById("confirmPassword");


        if (passwordField.type === "password") {
            passwordField.type = "text";
            confirmpasswordField.type = "text";
            eyeIcon.classList.remove("fa-eye-slash");
            eyeIcon.classList.add("fa-eye");
        } else {
            passwordField.type = "password";
            confirmpasswordField.type = "password";
            eyeIcon.classList.remove("fa-eye");
            eyeIcon.classList.add("fa-eye-slash");
        }

    }
    // Mengisi otomatis kata sandi saat halaman dimuat
    document.addEventListener("DOMContentLoaded", function() {
        const newPasswordElement = document.getElementById("newPassword");
        const passwordField = document.getElementById("newPassword2");
        const password = generateRandomPassword(); // Generate kata sandi acak
        newPasswordElement.textContent = password;

        passwordField.value = newPasswordElement.textContent
    });

    // Menambahkan event listener ke tombol "Show Password"
    document.getElementById("showPassword").addEventListener("click", togglePasswordVisibility);
</script>
@endsection

@push('js_in')
<script src="{{ asset('assets/customjs/users/users_input.js') }}"></script>
@endpush