@extends('layouts/app')

@section('content')
<div class="content">
    <div class="container-fluid">
        <div class="row">
            @if (session('status'))
            <div class="col-lg-12">
                <div class="alert alert-success alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <h4>Info!</h4>
                    {{ session('status') }}
                </div>
            </div>
            @endif
            @if (session('error'))
            <div class="col-lg-12">
                <div class="alert alert-danger alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <h4>Info!</h4>
                    {{ session('error') }}
                </div>
            </div>
            @endif
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Users</h3>
                        <div class="card-tools">
                            @if(auth()->user()->can('create-users'))
                            <a href="{{ url('/users/create') }}">
                                <button type="button" class="btn btn-primary btn-sm"><i class="fas fa-plus"></i>Add
                                </button>
                            </a>
                            @endif
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="list-data" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th width="1%">NO</th>
                                        <th>NAMA</th>
                                        <th>USERNAME</th>
                                        <th>EMAIL</th>
                                        <th>LEVEL</th>
                                        <th width="10%">ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    var access = @json($access);
    var authUserCanEdit = access.canEdit;
    var authUserCanDelete = access.canDelete;

    $(function() {
        $('#list-data').DataTable({
            processing: true,
            serverSide: true,
            order: [
                [0, "desc"]
            ],
            ajax: '/list-data-users',
            columns: [{
                    data: 'id',
                    render: function(data, type, row, meta) {
                        return meta.row + meta.settings._iDisplayStart + 1;
                    }
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'username',
                    name: 'username'
                },
                {
                    data: 'email',
                    name: 'email'
                },
                {
                    data: 'levelnama',
                    name: 'levelnama'
                },
                {
                    render: function(data, type, row) {
                        var editButton = authUserCanEdit ? '<a href="/users/' + row['id'] + '/edit" class="btn btn-success btn-xs"><i class="fa fa-wrench"></i></a>' : '';
                        var deleteButton = authUserCanDelete ? '<button class="btn btn-danger btn-xs" onclick="hapusdata(' + row['id'] + ')"><i class="fa fa-trash"></i></button>' : '';
                        return editButton + ' ' + deleteButton;
                    },
                    "className": 'text-center',
                    "orderable": false,
                    "data": null,
                },
            ],
            pageLength: 10,
            lengthMenu: [
                [5, 10, 20],
                [5, 10, 20]
            ],
            // Responsive settings
            responsive: true,
            autoWidth: false
        });

    });

    function hapusdata(kode) {
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: 'btn btn-success',
                cancelButton: 'btn btn-danger'
            },
            buttonsStyling: true
        })
        swalWithBootstrapButtons.fire({
            title: 'Are you sure you want to delete this data?', 
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes!',
            cancelButtonText: 'No',
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: 'DELETE',
                    url: '/users/' + kode,
                    data: {
                        '_token': $('input[name=_token]').val(),
                    },
                    success: function() {
                        swalWithBootstrapButtons.fire(
                            'Deleted!',
                            'Deleted successfully.',
                            'success'
                        )
                        $('#list-data').DataTable().ajax.reload();
                    },
                    error: function() {
                        swalWithBootstrapButtons.fire(
                            'Oops!',
                            'Delete failed',
                            'error'
                        )
                        $('#list-data').DataTable().ajax.reload();
                    }
                });
            }
        })
    }
  
</script>
@endsection