@extends('layouts.app')



@section('content')
    <section class="content container-fluid">
        <div class="row">
            @if ($message = Session::get('success'))
                <div class="col-md-12">
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {{ $message }}
                    </div>
                </div>
            @endif
                @if ($message = Session::get('danger'))
                    <div class="col-md-12">
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            {{ $message }}
                        </div>
                    </div>
                @endif
            <div class="col-md-12">

                @includeif('partials.errors')

                <div class="card card-default">
                    <div class="card-header" style="background-color: #632b8d; color:white;">
                        <span class="card-title">Tambah Whitelist IP</span>
                    </div>
                    <div class="card-body">
                        <form method="POST" id="myForm" action="{{ route('whitelist.store') }}"  role="form" enctype="multipart/form-data">
                            @csrf
                            <div class="box box-info padding-1">
                            @include('whitelist-ip.form')
                                <div class="box-footer mt20">
                                    <button type="submit" name="action" value="save_and_close"
                                        class="btn  bg-purple" id="btnSimpan">Simpan & Tutup</button>
                                    <a class="btn btn-danger float-right" href="{{ route('whitelist.index') }}"> Kembali</a>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('js')
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const btnSimpan = document.getElementById("btnSimpan");
            btnSimpan.addEventListener("click", function (event) {
                event.preventDefault();

                btnSimpan.innerHTML = "Menyimpan...";

                $.ajax({
                    url: '/whitelist/store',
                    type: 'POST',
                    data: $('#myForm').serialize(),
                    success: function(response) {
                        window.location.href = '/whitelist';
                    },
                    error: function(xhr, status, error) {
                        if (xhr.status == 422) {
                            var validationErrors = xhr.responseJSON.errors;
                            $('.text-danger').text('');
                            $.each(validationErrors, function (field, messages) {
                                $('#'+field+'-error').text(messages[0]);
                            });
                        } else {
                            alert('Terjadi kesalahan: ' + error);
                        }
                        setTimeout(function () {
                            btnSimpan.disabled = false;
                            btnSimpan.innerHTML = "Simpan & Tutup";
                        }, 3000);
                    }

                });
                setTimeout(function () {
                    btnSimpan.disabled = true;
                    btnSimpan.innerHTML = "Tersimpan";
                }, 50);
            });
        });

        document.addEventListener("DOMContentLoaded", function () {
            const btnSimpan = document.getElementById("saveButon");
            btnSimpan.addEventListener("click", function (event) {
                event.preventDefault();

                btnSimpan.innerHTML = "Menyimpan...";

                $.ajax({
                    url: '/whitelist/store',
                    type: 'POST',
                    data: $('#myForm').serialize(),
                    success: function(response) {
                        alert('Data berhasil disimpan');
                        location.reload();
                    },
                    error: function(xhr, status, error) {
                        if (xhr.status == 422) {
                            if (xhr.status == 422) {

                                var validationErrors = xhr.responseJSON.errors;

                                var errorMessage = '';
                                $.each(validationErrors, function (field, messages) {
                                    $.each(messages, function (key, message) {
                                        errorMessage += message + '\n';
                                    });
                                });
                                alert(errorMessage);
                            } else {
                                alert('Terjadi kesalahan: ' + error);
                            }
                            setTimeout(function () {
                                btnSimpan.disabled = false;
                                btnSimpan.innerHTML = "Simpan & Tutup";
                            }, 3000);
                        }                        setTimeout(function () {
                            btnSimpan.disabled = false;
                            btnSimpan.innerHTML = "Simpan";
                        }, 3000);
                    }

                });
                setTimeout(function () {
                    btnSimpan.disabled = true;
                    btnSimpan.innerHTML = "Tersimpan";
                }, 50);
            });
        });
    </script>
@endsection
