<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\api\MobileController;
use App\Http\Controllers\api\RajaGadaiInController;
use App\Http\Controllers\api\RajaGadaiOutController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

// =================================== Route Aplikasi
Route::middleware('auth.api')->group(function () {
    Route::post('/logout', [MobileController::class, 'logout']);
    Route::get('/referrals', [MobileController::class, 'referrals']);
    Route::get('/my-vouchers', [MobileController::class, 'vouchers']);
    Route::get('/my-vouchers/{id}', [MobileController::class, 'vouchersId']);
    Route::put('/my-vouchers/{id}/use', [MobileController::class, 'vouchersUse']);
    Route::get('/memberships', [MobileController::class, 'membership']);
    Route::get('/points', [MobileController::class, 'points']);
    Route::get('/points/histories', [MobileController::class, 'histories']);
    Route::get('/points/vouchers/{id}', [MobileController::class, 'pointsVoucher']);
    Route::put('/points/vouchers/{id}/redeem', [MobileController::class, 'redeem']);
    Route::put('/coin/vouchers/{id}/{oid}/redeem-gb', [MobileController::class, 'redeemGB']);
    Route::get('/stores', [MobileController::class, 'store']);
    Route::get('/stores/{id}', [MobileController::class, 'storeId']);
    Route::get('/dashboards/articles', [MobileController::class, 'articles']);
    Route::get('/dashboards/banners', [MobileController::class, 'berita']);
    Route::get('/dashboards/common', [MobileController::class, 'common']);
    Route::get('/dashboards/ongoing-pawn', [MobileController::class, 'ongoingPawn']);
    Route::get('/gadai', [MobileController::class, 'gadai']);
    Route::get('/gadai/histories', [MobileController::class, 'gadaiHistories']);
    Route::get('/notifications', [MobileController::class, 'notifications']);
    Route::put('/notifications/{id}/mark-as-read', [MobileController::class, 'markAsRead']);
    Route::put('/notifications/mark-all-as-read', [MobileController::class, 'markAllAsRead']);
    Route::get('/simulations/resources', [MobileController::class, 'simulationResources']);
    Route::post('/simulations', [MobileController::class, 'simulations']);
    Route::get('/notifications/unreads', [MobileController::class, 'notificationUnread']);

    Route::get('/my-account', [MobileController::class, 'account']);
    Route::get('/my-profile', [MobileController::class, 'profile']);
    Route::post('/my-profile/change-image-profile', [MobileController::class, 'changeImageProfile']);
    Route::put('/change-password', [MobileController::class, 'changePassword']);
    Route::put('/fcm-token', [MobileController::class, 'fcmTokenFirebase']);
    Route::get('/pawns', [MobileController::class, 'pawns']);
    Route::get('/pawns/ongoing', [MobileController::class, 'pawnOngoing']);
    Route::get('/pawns/{id}', [MobileController::class, 'pawnsId']);
    Route::put('/pawns/{id}/extend', [MobileController::class, 'extend']);
    Route::put('/pawns/{id}/payment', [MobileController::class, 'payment']);
    Route::get('/my-vouchers-points', [MobileController::class, 'voucherPoints']);
    Route::get('/memberships/histories', [MobileController::class, 'memberHistories']);
    Route::get('/history-vouchers', [MobileController::class, 'voucherHistories']);
});
Route::get('/greetings', [MobileController::class, 'greetings']);
Route::get('/register/send-otp', [MobileController::class, 'sendOtp']);
Route::post('/sign-in', [MobileController::class, 'signIn']);
Route::post('/verify', [MobileController::class, 'verifyAccount']);
Route::post('/register', [MobileController::class, 'register']);
Route::get('/forget-password/send-otp', [MobileController::class, 'sendOtp2']);
Route::put('/reset-password', [MobileController::class, 'resetPassword']);
Route::post('/sign-in-as-guest', [MobileController::class, 'guest']);
Route::get('/welcome', [MobileController::class, 'checkServer']);
Route::get('/otp-configs', [MobileController::class, 'otpConfig']);
Route::post('/verify/phone-number', [MobileController::class, 'verifyPhoneNumber']);



// =================================================== Route Raja Gadai In
Route::middleware('whitelist')->group(function () {
    Route::get('/token', [RajaGadaiInController::class, 'token']);
    Route::get('/check-point', [RajaGadaiInController::class, 'checkPoint']);
    Route::post('/gadai-new', [RajaGadaiInController::class, 'gadai']);
    Route::post('/gadai-extend', [RajaGadaiInController::class, 'extend']);
    Route::post('/payment-gadai', [RajaGadaiInController::class, 'payment']);
    Route::post('/cancel-gadai-extend', [RajaGadaiInController::class, 'cancelPaymentExtend']);
    Route::post('/cancel-payment', [RajaGadaiInController::class, 'cancelPayment']);
    Route::post('/cancel-gadai', [RajaGadaiInController::class, 'cancelGadai']);
    // Route::middleware('signature')->group(function () {

    // });

});

//Route::get('/test', [MobileController::class,'generateNumber']);
