<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\api\APIController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/check-version', [APIController::class, 'checkVersions']);
Route::get('/destinations', [APIController::class, 'getDestinations']);
Route::get('/lot-processes', [APIController::class, 'getLotProcesses']);
Route::get('/cases', [APIController::class, 'getCases']);
Route::get('/mappings', [APIController::class, 'getMappings']);
