<?php

use App\Http\Controllers\HistoryExtendController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\JobLogController;
use App\Http\Controllers\LiburNasionalController;
use App\Http\Controllers\MasterConfigController;
use App\Http\Controllers\RiwayatPointController;
use App\Http\Controllers\RiwayatXpController;
use App\Http\Controllers\SplashScreenController;
use App\Http\Controllers\WhitelistIpController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RolesController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\SettingWebController;
use App\Http\Controllers\RiwayatCouponController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\CustomerCouponController;
use App\Http\Controllers\CouponController;
use App\Http\Controllers\PointController;
use App\Http\Controllers\LevelController;
use App\Http\Controllers\LevelPointController;
use App\Http\Controllers\GeraiController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\BeritaController;
use App\Http\Controllers\DataGadaiController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\KategoriController;
use App\Http\Controllers\BrandController;
use App\Http\Controllers\ItemController;
use App\Http\Controllers\GradeController;
use App\Http\Controllers\TopupPointController;
use App\Http\Controllers\DeductPointController;
use App\Http\Controllers\DefectController;
use App\Http\Controllers\RiwayaMutasiPointController;
use App\Http\Controllers\PromoPointController;
use App\Http\Controllers\VoucherPromoPointController;

Route::get('/', function () {
    return view('auth.login');
})->middleware('guest');

Auth::routes([
'register' => false,
'reset' => false,
'verify' => false,
]);

//===========================================================================================Home
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/home/edit-profile', [App\Http\Controllers\HomeController::class, 'editprofile']);
Route::post('/home/edit-profile', [App\Http\Controllers\HomeController::class, 'aksieditprofile']);

//===========================================================================================Users
Route::get('/list-data-users',[UserController::class,'listdata']);
Route::resource('users', UserController::class);

//===========================================================================================Roles
Route::get('/list-data-roles',[RolesController::class,'listdata']);
Route::resource('roles', RolesController::class);

//===========================================================================================Permission
Route::get('/list-data-permission',[PermissionController::class,'listdata']);

Route::resource('permission', PermissionController::class);

//===========================================================================================Setting-Web
Route::get('/setting-web',[SettingWebController::class,'index']);
Route::post('/setting-web',[SettingWebController::class,'store']);

//============================================================================================Route Resource
Route::resource('customer', CustomerController::class);
Route::get('/reset-password-customer', [CustomerController::class, 'resetPassword'])->name('customer.reset-password');
Route::get('/search-referal', [CustomerController::class, 'searchRef'])->name('customer.referal');
Route::get('/list-kodeReferal/{id}',[CustomerController::class, 'listDetailReferral']);

Route::get('/riwayatCoupon', [RiwayatCouponController::class, 'index'])->name('riwayatCoupon.index');
Route::get('/search-riwayatCoupon', [RiwayatCouponController::class, 'search'])->name('riwayat.search');
Route::get('/export-riwayat-coupon', [RiwayatCouponController::class, 'export']);
Route::get('/export-riwayat-coupon-all', [RiwayatCouponController::class, 'export_all']);
Route::get('/export-referal', [CustomerController::class, 'exportReport']);
Route::get('/export-referal-all', [CustomerController::class, 'exportReportAll']);
Route::resource('coupon', CouponController::class);

Route::get('/riwayatPoint', [RiwayatPointController::class,'index'])->name('riwayatPoint.index');
Route::get('/search-riwayatPoint', [RiwayatPointController::class,'search'])->name('riwayatPoint.search');
Route::get('/export-search-riwayatPoint', [RiwayatPointController::class, 'export']);
Route::get('/export-search-riwayatPoint-all', [RiwayatPointController::class, 'export_all']);
Route::get('/riwayatXp', [RiwayatXpController::class, 'index'])->name('riwayatXp.index');
Route::get('/search-riwayatXp', [RiwayatXpController::class, 'search'])->name('riwayatXp.search');
Route::get('/export-search-riwayatXp', [RiwayatXpController::class, 'export']);
Route::get('/export-search-riwayatXp-all', [RiwayatXpController::class, 'export_all']);
Route::get('/export-riwayat-xp-detail/{id}', [RiwayatXpController::class, 'export_detail']);
Route::get('/detail-riwayatXp/{id}', [RiwayatXpController::class,'detail'])->name('riwayatXp.detail');
Route::get('/riwayatMutasiPoint', [RiwayaMutasiPointController::class, 'index'])->name('riwayaMutasiPoint.index');
Route::get('/search-riwayatMutasiPoint', [RiwayaMutasiPointController::class, 'search'])->name('riwayatMutasiPoint.search');
Route::get('/export-riwayat-mutasi-point', [RiwayaMutasiPointController::class, 'export']);
Route::get('/export-riwayat-mutasi-point-all', [RiwayaMutasiPointController::class, 'export_all']);
Route::get('/export-riwayat-point-detail/{id}', [RiwayaMutasiPointController::class, 'export_detail']);
Route::get('/detail-riwayatPoint/{id}', [RiwayaMutasiPointController::class, 'detail'])->name('riwayatPoint.detail');
Route::get('/search-HistoryExtend', [HistoryExtendController::class,'search'])->name('HistoryExtend.search');
Route::get('/HistoryExtend/{id}',[HistoryExtendController::class,'show']);
Route::get('/search-job',[JobLogController::class,'search'])->name('job.search');

Route::resource('customerCoupon', CustomerCouponController::class);
Route::resource('points', PointController::class);
Route::resource('levels', LevelController::class);
// Route::resource('level-points', LevelPointController::class);
Route::resource('gerai', GeraiController::class);
Route::resource('notification', NotificationController::class);
Route::resource('news', BeritaController::class);
Route::resource('data-gadai', DataGadaiController::class);
Route::resource('payment', PaymentController::class);
Route::resource('Kategori', KategoriController::class);
Route::resource('Brand', BrandController::class);
Route::resource('Item', ItemController::class);
Route::resource('Grade', GradeController::class);
Route::resource('liburNasional', LiburNasionalController::class);
Route::resource('topup', TopupPointController::class);
Route::resource('deduct', DeductPointController::class);
Route::resource('defect', DefectController::class);
Route::resource('splash', SplashScreenController::class);
Route::resource('whitelist', WhitelistIpController::class);
Route::resource('HistoryExtend', HistoryExtendController::class);
Route::resource('masterConfig',MasterConfigController::class);
Route::resource('job', JobLogController::class);
Route::resource('promo-point', PromoPointController::class);
Route::resource('voucher-gb', VoucherPromoPointController::class);
//================================================== Route Save
Route::post('/news/store', [BeritaController::class, 'store']);
Route::post('/Brand/store', [BrandController::class, 'store']);
Route::post('/coupon/store', [CouponController::class, 'store']);
Route::post('/coupon/{id}', [CouponController::class, 'update']);
Route::post('/customer/store', [CustomerController::class, 'store']);
Route::post('/deduct/store', [DeductPointController::class,'store']);
Route::post('/defect/store', [DefectController::class,'store']);
Route::post('/gerai/store', [GeraiController::class,'store']);
Route::post('/Grade/store', [GradeController::class,'store']);
Route::post('/Item/store', [ItemController::class, 'store']);
Route::post('/Kategori/store', [KategoriController::class, 'store']);
Route::post('/levels/store', [LevelController::class, 'store']);
Route::post('/level-points/store', [LevelPointController::class,'store']);
Route::post('/liburNasional/store', [LiburNasionalController::class,'store']);
Route::post('/notification/store', [NotificationController::class, 'store']);
Route::post('/points/store', [PointController::class, 'store']);
Route::post('/splash/store', [SplashScreenController::class,'store']);
Route::post('/topup/store', [TopupPointController::class,'store']);
Route::post('/whitelist/store', [WhitelistIpController::class,'store']);
Route::post('/promo-point/store', [PromoPointController::class,'store']);
Route::post('/voucher-gb/store', [VoucherPromoPointController::class,'store']);
//=================================================== Route Custom
Route::get('/referal', [CustomerController::class, 'referal'])->name('referal');
Route::delete('/delete-jam-buka/{id}', [GeraiController::class, 'del']);
Route::get('/liburNasional/{geraiId}/{id}', [LiburNasionalController::class, 'saveDetail']);
Route::get('/levels/{couponId}/{levelId}',[LevelController::class, 'savebenefit']);
Route::get('/get-parameter/{id}', [NotificationController::class, 'getParameter']);
Route::get('/job/{id}/resend', [JobLogController::class, 'resend']);

Route::get('/uploadLibur/', [LiburNasionalController::class, 'uploadLibur']);
Route::get('/uploadLibur/template_excell', [LiburNasionalController::class, 'templateLibur']);
Route::post('/uploadLibur/', [LiburNasionalController::class, 'uploadStore'])->name('uploadStoreLibur');


Route::get('/upload-item/', [ItemController::class, 'uploadItem']);
Route::get('/upload-item/template_excell', [ItemController::class, 'templateItem']);
Route::post('/upload-item/', [ItemController::class, 'uploadStore'])->name('uploadStoreItem');
//================================================== Route List

Route::get('/list-gerai', [GeraiController::class,'listdata']);
Route::get('/list-customer', [CustomerController::class, 'listdata']);
Route::get('/list-coupon', [CouponController::class, 'listdata']);
Route::get('/list-poin', [PointController::class,'listdata']);
Route::get('/list-level', [LevelController::class, 'listdata']);
Route::get('/list-benefit/{id}', [LevelController::class, 'listbenefit']);
Route::delete('/benefit/{id}', [LevelController::class, 'deletebenefit']);
Route::get('/list-xp', [LevelPointController::class, 'listdata']);
Route::get('/list-notifikasi', [NotificationController::class, 'listdata']);
Route::get('/list-promosi', [BeritaController::class, 'listdata']);
Route::get('/list-gadai', [DataGadaiController::class, 'listdata']);
Route::get('/list-riwayatKupon', [RiwayatCouponController::class, 'listdata']);
Route::get('/list-payment', [PaymentController::class, 'listdata']);
Route::get('/list-referal', [CustomerController::class, 'listref']);
Route::get('/list-libur', [LiburNasionalController::class, 'listdata']);
Route::get('/list-liburDetail/{id}', [LiburNasionalController::class, 'listdetail']);
Route::delete('/liburDetail/{id}', [LiburNasionalController::class, 'deleteDetail']);
Route::get('/list-kategori', [KategoriController::class, 'listdata']);
Route::get('/list-brand', [BrandController::class, 'listdata']);
Route::get('/list-item', [ItemController::class, 'listdata']);
Route::get('/item-barang/{id}', [ItemController::class, 'getBrand']);
Route::get('/list-grade', [GradeController::class, 'listdata']);
Route::get('/list-topup', [TopupPointController::class, 'listdata']);
Route::get('/list-deduct', [DeductPointController::class, 'listdata']);
Route::get('/list-gadai', [DataGadaiController::class, 'listdata']);
Route::get('/list-defact', [DefectController::class, 'listdata']);
Route::get('/list-splash', [SplashScreenController::class, 'listdata']);
Route::get('/list-ip', [WhitelistIpController::class, 'listdata']);
Route::get('/list-history-extend', [HistoryExtendController::class, 'listdata']);
Route::get('/list-config', [MasterConfigController::class, 'listdata']);
Route::get('/list-job', [JobLogController::class, 'listdata']);
Route::get('/list-gerai-libur/{id}', [LiburNasionalController::class,'listgerai']);
Route::get('/libur-nasional-add/{id}', [LiburNasionalController::class,'listgerai']);
Route::get('/list-promo-point', [PromoPointController::class, 'listdata']);
Route::get('/list-voucher-promo-point', [VoucherPromoPointController::class, 'listdata']);
// ===================================== Route Excel
Route::get('/customers/excel_all', [CustomerController::class,'export_all']);
Route::get('/coupons/excel_all', [CouponController::class,'export_all']);
Route::get('/point/excel_all', [PointController::class,'export_all']);
Route::get('/level/excel_all', [LevelController::class,'export_all']);
Route::get('/level-point/excel_all', [LevelPointController::class,'export_all']);
Route::get('/gerais/excel_all', [GeraiController::class,'export_all']);
Route::get('/notifications/excel_all', [NotificationController::class,'export_all']);
Route::get('/newses/excel_all', [BeritaController::class,'export_all']);
Route::get('/data-gadais/excel_all', [DataGadaiController::class,'export_all']);
Route::get('/payments/excel_all', [PaymentController::class,'export_all']);
Route::get('/defects/excel_all', [DefectController::class,'export_all']);
Route::get('/grades/excel_all', [GradeController::class,'export_all']);
Route::get('/brands/excel_all', [BrandController::class,'export_all']);
Route::get('/items/excel_all', [ItemController::class,'export_all']);
Route::get('/kategoris/excel_all', [KategoriController::class,'export_all']);
Route::get('/topups/excel_all', [TopupPointController::class,'export_all']);
Route::get('/deducts/excel_all', [DeductPointController::class,'export_all']);
Route::get('/liburnasionals/excel_all', [LiburNasionalController::class,'export_all']);
Route::get('/riwayat-extend/excel_all', [HistoryExtendController::class,'export_all']);
Route::get('/riwayat-extend/export_excel_all', [HistoryExtendController::class,'export_excel_all']);


/// upload excell
Route::get('/upload_customer', [CustomerController::class,'uploadCustomer']);
Route::get('/upload_customer/template', [CustomerController::class,'template']);
Route::post('/upload_customer', [CustomerController::class,'uploadStore'])->name('uploadStore');
Route::post('/customer-excel', [CustomerController::class,'lihatData']);
Route::get('/upload_outlet/', [GeraiController::class, 'upload']);
Route::post('/upload_outlet',[GeraiController::class, 'uploadOutlet'])->name('uploadOutlet');
Route::get('/pesan', [HomeController::class,'showFormPesan']);
Route::get('/pesan-create', [HomeController::class, 'showFormPesan'])->name('fcmToken');
Route::patch('/fcm-token', [HomeController::class, 'updateToken'])->name('fcmToken');
Route::post('/send-notification',[HomeController::class,'notification'])->name('notification');
Route::get('/reset-password', [UserController::class, 'resetPassword'])->name('users.reset-password');
Route::post('/resend-job', [JobLogController::class,'resend']);
