<?php


use App\Http\Controllers\ScheduleSyncController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HistoryExtendController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RolesController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\SettingWebController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\MasterConfigController;
use App\Http\Controllers\DestinationController;
use App\Http\Controllers\WhitelistIpController;
use \App\Http\Controllers\ItemController;
use \App\Http\Controllers\CaseController;
use \App\Http\Controllers\LotProcessController;
use \App\Http\Controllers\MappingController;

Route::get('/', function () {
    return view('auth.login');
})->middleware('guest');

Auth::routes([
    'register' => false,
    'reset' => false,
    'verify' => false,
]);

//===========================================================================================Home
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/home/edit-profile', [App\Http\Controllers\HomeController::class, 'editprofile']);
Route::post('/home/edit-profile', [App\Http\Controllers\HomeController::class, 'aksieditprofile']);
Route::get('/pesan', [HomeController::class, 'showFormPesan']);
Route::get('/pesan-create', [HomeController::class, 'showFormPesan'])->name('fcmToken');
//===========================================================================================Users
Route::get('/list-data-users', [UserController::class, 'listdata']);
Route::get('users/reset-password', [UserController::class, 'showResetPasswordForm'])->name('users.reset-password');
Route::post('users/reset-password', [UserController::class, 'resetPassword'])->name('users.reset-password.submit');
Route::resource('users', UserController::class);
//===========================================================================================Roles
Route::get('/list-data-roles', [RolesController::class, 'listdata']);
Route::resource('roles', RolesController::class);
//===========================================================================================Permission
Route::get('/list-data-permission', [PermissionController::class, 'listdata']);
Route::resource('permission', PermissionController::class);
//===========================================================================================Setting-Web
Route::get('/setting-web', [SettingWebController::class, 'index']);
Route::post('/setting-web', [SettingWebController::class, 'store']);
//============================================================================================masterConfig
Route::resource('masterConfig', MasterConfigController::class);
Route::get('/list-config', [MasterConfigController::class, 'listdata']);
 
 
// ==============================================================================================masterDestination
Route::get('/list-destinations', [DestinationController::class, 'listdata']);
Route::post('/destinations/store', [DestinationController::class, 'store']);
Route::get('/destinations/excel', [DestinationController::class, 'excelAll'])->name('destinations.excel_all');
Route::get('/destinations/template', [DestinationController::class, 'downloadTemplate'])->name('destinations.download_template');
Route::get('/destinations/upload', [DestinationController::class, 'showUploadForm'])->name('destinations.upload_form');
Route::post('/destinations/upload', [DestinationController::class, 'upload'])->name('destinations.upload');
Route::resource('destinations', DestinationController::class);
Route::get('destinations/download-error/{file}', function ($file) {
    return response()->download(storage_path("app/$file"));
})->name('destinations.downloadError');

// ==============================================================================================masterItem

Route::get('/list-items', [ItemController::class, 'listdata']);
Route::post('/items/store', [ItemController::class, 'store']);
Route::get('/items/excel', [ItemController::class, 'excelAll'])->name('items.excel_all');
Route::get('/items/template', [ItemController::class, 'downloadTemplate'])->name('items.download_template');
Route::get('/items/upload', [ItemController::class, 'showUploadForm'])->name('items.upload_form');
Route::post('/items/upload', [ItemController::class, 'upload'])->name('items.upload');
Route::resource('/items', ItemController::class)->middleware('auth');
Route::get('items/download-error/{file}', function ($file) {
    return response()->download(storage_path("app/$file"));
})->name('items.downloadError');


// ==============================================================================================masterCase
Route::get('/list-case', [CaseController::class, 'listdata']);
Route::post('/case/store', [CaseController::class, 'store']);
Route::get('/case/excel', [CaseController::class, 'excelAll'])->name('case.excel_all');
Route::get('/case/template', [CaseController::class, 'downloadTemplate'])->name('case.download_template');
Route::get('/case/upload', [CaseController::class, 'showUploadForm'])->name('case.upload_form');
Route::post('/case/upload', [CaseController::class, 'upload'])->name('case.upload');
Route::resource('/case', CaseController::class)->middleware('auth');
Route::get('case/download-error/{file}', function ($file) {
    return response()->download(storage_path("app/$file"));
})->name('case.downloadError');



// ==============================================================================================masterLotProcess
Route::get('/list-lot-process', [LotProcessController::class, 'listdata']);
Route::post('/lot-process/store', [LotProcessController::class, 'store']);
Route::get('/lot-process/excel', [LotProcessController::class, 'excelAll'])->name('lot-process.excel_all');
Route::get('/lot-process/template', [LotProcessController::class, 'downloadTemplate'])->name('lot-process.download_template');
Route::get('/lot-process/upload', [LotProcessController::class, 'showUploadForm'])->name('lot-process.upload_form');
Route::post('/lot-process/upload', [LotProcessController::class, 'upload'])->name('lot-process.upload');
Route::resource('/lot-process', LotProcessController::class)->middleware('auth');
Route::get('lot-process/download-error/{file}', function ($file) {
    return response()->download(storage_path("app/$file"));
})->name('lot-process.downloadError');


// ==============================================================================================masterMapping

Route::get('/list-mapping', [MappingController::class, 'listdata'])->name('mapping.listdata');

Route::get('/fetch-item-data/{id}', [ItemController::class, 'fetchItemData']);
Route::get('/mapping/excel', [MappingController::class, 'excelAll'])->name('mapping.excel_all');
Route::get('/mapping/template', [MappingController::class, 'downloadTemplate'])->name('mapping.download_template');
Route::get('/mapping/upload', [MappingController::class, 'showUploadForm'])->name('mapping.upload_form');
// Route::post('/mapping/upload', [MappingController::class, 'upload'])->name('mapping.upload');
Route::post('/mapping/import', [MappingController::class, 'import'])->name('mapping.import');
Route::get('/mapping/download-error/{file}', [MappingController::class, 'downloadError'])->name('mapping.downloadError');
Route::resource('/mapping', MappingController::class)->middleware('auth');


// =============================================================================================SheduleSync

Route::get('/list-schedule-sync', [ScheduleSyncController::class, 'listdata'])->name('schedule-sync.listdata');
Route::resource('/schedule-sync', ScheduleSyncController::class)->middleware('auth');

