<?php $__env->startSection('content'); ?>
<div class="content">
    <div class="container-fluit">
        <?php if(session('status')): ?>
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h4>Info!</h4>
            <?php echo e(session('status')); ?>

        </div>
        <?php endif; ?>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header ">
                        <h3 class="card-title">Roles</h3>
                        <div class="card-tools">
                            <?php if(auth()->user()->can('create-roles')): ?>
                            <a href="<?php echo e(url('/roles/create')); ?>">
                                <button type="button" class="btn btn-primary btn-xs"><i class="fas fa-plus"></i> Add
                                </button>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="list-data" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th width="1%">NO</th>
                                        <th>ROLE</th>
                                        <th>PERMISSION</th>
                                        <th class="text-center">ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</div>
<script>
    var access = <?php echo json_encode($access, 15, 512) ?>;
    var authUserCanEdit = access.canEdit;
    var authUserCanDelete = access.canDelete;

    $(function() {
        $('#list-data').DataTable({
            processing: true,
            serverSide: true,
            order: [
                [0, "desc"]
            ],
            ajax: '/list-data-roles',
            columns: [{
                    data: 'id',
                    render: function(data, type, row, meta) {
                        return meta.row + meta.settings._iDisplayStart + 1;
                    }
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    render: function(data, type, row) {
                        return row['total'] + ' Permission'
                    },
                    "className": 'text-center',
                    "orderable": false,
                    "data": 'total',
                },
                {
                    render: function(data, type, row) {
                        if (row['id'] != 1) {
                            var editButton = authUserCanEdit ? '<a href="/roles/' + row['id'] + '/edit" class="btn btn-success btn-xs"><i class="fa fa-wrench"></i></a>' : '';
                            var deleteButton = authUserCanDelete ? ' <button class="btn btn-danger btn-xs" onclick="hapusdata(' + row['id'] + ')"><i class="fa fa-trash"></i></button>' : '';
                            return editButton + ' ' + deleteButton;
                        } else {
                            var editButton = authUserCanEdit ? '<a href="/roles/' + row['id'] + '/edit" class="btn btn-success btn-xs"><i class="fa fa-wrench"></i></a>' : '';
                            return editButton;
                        }

                    },
                    "className": 'text-center',
                    "orderable": false,
                    "data": null,
                },
            ],
            pageLength: 10,
            lengthMenu: [
                [5, 10, 20],
                [5, 10, 20]
            ],
            // Responsive settings
            responsive: true,
            autoWidth: false
        });

    });

    function hapusdata(kode) {
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: 'btn btn-success',
                cancelButton: 'btn btn-danger'
            },
            buttonsStyling: true
        })
        swalWithBootstrapButtons.fire({
            title: 'Are you sure you want to delete this data?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes!',
            cancelButtonText: 'No',
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: 'DELETE',
                    url: '/roles/' + kode,
                    data: {
                        '_token': $('input[name=_token]').val(),
                    },
                    success: function(response) {
                        swalWithBootstrapButtons.fire(
                            'Deleted!',
                            response.message,
                            'success'
                        )
                        $('#list-data').DataTable().ajax.reload();
                    },
                    error: function(xhr, status, error, response) {
                        swalWithBootstrapButtons.fire(
                            'Oops!',
                            'Deleted Failed',
                            'error'
                        )
                    }
                });
            }
        })
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/toyota/resources/views/roles/index.blade.php ENDPATH**/ ?>