<nav class="mt-2">
    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
        <li class="nav-item">
            <a href="<?php echo e(url('/home')); ?>" class="nav-link <?php echo e(request()->is('home') ? 'active' : ''); ?>">
                <i class="nav-icon fas fa-tachometer-alt"></i>
                <p>Beranda</p>
            </a>
        </li>

        <li class="nav-item has-treeview <?php echo e(request()->is('destinations*') || request()->is('lot-process*') || request()->is('case*') || request()->is('items*') ? 'menu-open' : ''); ?>">
            <a href="#" class="nav-link">
                <i class="nav-icon fas fa-table"></i>
                <p>
                    Master
                    <i class="fas fa-angle-left right"></i>
                </p>
            </a>
            <ul class="nav nav-treeview">
                <li class="nav-item">
                    <a href="<?php echo e(url('destinations')); ?>" class="nav-link <?php echo e(request()->is('destinations*') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Destination</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(url('lot-process')); ?>" class="nav-link <?php echo e(request()->is('lot-process*') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Lot Process</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(url('case')); ?>" class="nav-link <?php echo e(request()->is('case*') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Case</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(url('items')); ?>" class="nav-link <?php echo e(request()->is('items*') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Part Number</p>
                    </a>
                </li>
            </ul>
        </li>
        <li class="nav-item has-treeview <?php echo e(request()->is('mapping*') ? 'menu-open' : ''); ?>">
            <a href="#" class="nav-link">
                <i class="nav-icon fas fa-exchange-alt"></i>
                <p>
                    Transaction
                    <i class="fas fa-angle-left right"></i>
                </p>
            </a>
            <ul class="nav nav-treeview">
                <li class="nav-item">
                    <a href="<?php echo e(route('mapping.index')); ?>" class="nav-link">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Mapping</p>
                    </a>
                </li>
            </ul>
        </li>

        <?php if(
        auth()->user()->can('view-users') ||
        auth()->user()->can('create-users') ||
        auth()->user()->can('edit-users') ||
        auth()->user()->can('delete-users') ||
        auth()->user()->can('view-roles') ||
        auth()->user()->can('create-roles') ||
        auth()->user()->can('edit-roles') ||
        auth()->user()->can('delete-roles') ||
        auth()->user()->can('view-permission') ||
        auth()->user()->can('create-permission') ||
        auth()->user()->can('edit-permission') ||
        auth()->user()->can('delete-permission')
        ): ?>
        <li class="nav-item has-treeview <?php echo e(request()->is('permission*') || request()->is('roles*') || request()->is('users*') ? 'menu-open' : ''); ?>">
            <a href="#" class="nav-link">
                <i class="nav-icon fas fa-users"></i>
                <p>
                    Users Management
                    <i class="fas fa-angle-left right"></i>
                </p>
            </a>
            <ul class="nav nav-treeview">
                <?php if(auth()->user()->can('view-permission')): ?>
                <li class="nav-item">
                    <a href="<?php echo e(url('permission')); ?>" class="nav-link <?php echo e(request()->is('permission*') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Permission</p>
                    </a>
                </li>
                <?php endif; ?>
                <?php if(auth()->user()->can('view-roles')): ?>
                <li class="nav-item">
                    <a href="<?php echo e(url('roles')); ?>" class="nav-link <?php echo e(request()->is('roles*') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Roles</p>
                    </a>
                </li>
                <?php endif; ?>
                <?php if(auth()->user()->can('view-users')): ?>
                <li class="nav-item">
                    <a href="<?php echo e(url('users')); ?>" class="nav-link <?php echo e(request()->is('users*') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Users</p>
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>

        <?php if(
        auth()->user()->can('view-whitelist') ||
        auth()->user()->can('view-config') ||
        auth()->user()->can('view-job')
        ): ?>
        <!-- Configuration section is commented out -->
        <?php endif; ?>
    </ul>
</nav>

<script>
    $(document).ready(function() {
        // Toggle the submenu on click
        $('.nav-item.has-treeview > a').on('click', function(e) {
            e.preventDefault();
            var parent = $(this).parent();
            var submenu = $(this).next('.nav-treeview');
            if (parent.hasClass('menu-open')) {
                submenu.slideUp(200, function() {
                    parent.removeClass('menu-open');
                });
            } else {
                // Close all other open submenus
                $('.nav-item.has-treeview').removeClass('menu-open').find('.nav-treeview').slideUp(200);
                submenu.slideDown(200, function() {
                    parent.addClass('menu-open');
                });
            }
        });

        // Keep submenu open if an item within it is clicked
        $('.nav-treeview .nav-item > a').on('click', function(e) {
            e.stopPropagation();
        });
    });
</script><?php /**PATH /var/www/html/toyota/resources/views/layouts/sidebar.blade.php ENDPATH**/ ?>