<?php $__env->startSection('content'); ?>
<div class="content-header">
    <div class="row">
        <?php if($message = Session::get('success')): ?>
        <div class="col-md-12">
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <?php echo e($message); ?>

            </div>
        </div>
        <?php endif; ?>
        <?php if($message = Session::get('erorr')): ?>
        <div class="col-md-12">
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <?php echo e($message); ?>

            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<section class="content">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title float-left"><?= $datas['title'] ?></div>
                    <div class="card-title float-right">
                        <?php if($access['canDownload']): ?>
                        <a href="<?php echo e(route('mapping.download_template')); ?>" class="btn btn-info btn-xs"><i class="fa fa-file" aria-hidden="true"></i> Download Template</a>
                        <?php endif; ?>
                        <?php if($access['canUpload']): ?>
                        <a href="<?php echo e(route('mapping.upload_form')); ?>" class="btn btn-warning btn-xs"><i class="fa fa-arrow-up" aria-hidden="true"></i> Upload</a>
                        <?php endif; ?>
                        <?php if($access['canExport']): ?>
                        <a href="<?php echo e(route('mapping.excel_all')); ?>" class="btn btn-success btn-xs"><i class="fa fa-arrow-down" aria-hidden="true"></i> Export</a>
                        <?php endif; ?>
                        <?php if($access['canCreate']): ?>
                        <a href="<?php echo e(route('mapping.create')); ?>" class="btn btn-primary btn-xs"><i class="fas fa-plus"> </i> Add</a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <table id="list-data" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th width="1%">NO</th>
                                <th>DESTINATION</th>
                                <th>LOT PROCESS</th>
                                <th>CASE</th>
                                <th>START DATE</th>
                                <th>END DATE</th>
                                <th width="10%">ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
    var access = <?php echo json_encode($access, 15, 512) ?>;
    var authUserCanEditData = access.canEdit;
    var authUserCanDeleteData = access.canDelete;
    $(function() {
        $('#list-data').DataTable({
            processing: true,
            serverSide: true,
            order: [
                [0, "desc"]
            ],
            ajax: '/list-mapping',
            columns: [{
                    data: 'id',
                    render: function(data, type, row, meta) {
                        return meta.row + meta.settings._iDisplayStart + 1;
                    }
                },
                {
                    data: 'destination_name',
                    name: 'destination_name'
                },
                {
                    data: 'lot_process_name',
                    name: 'lot_process_name'
                },
                {
                    data: 'case_name',
                    name: 'case_name'
                },
                {
                    data: 'start_date',
                    name: 'start_date'
                },
                {
                    data: 'end_date',
                    name: 'end_date'
                },
                {
                    render: function(data, type, row) {
                        var editButton = authUserCanEditData ? ' <a href="/mapping/' + row['id'] + '/edit" class="btn btn-success btn-xs"><i class="fas fa-pencil-alt"></i></a> ' : '';
                        var deleteButton = authUserCanDeleteData ? '<button class="btn btn-danger btn-xs" onclick="deleteData(' + row['id'] + ')"><i class="fa fa-trash"></i></button>' : '';
                        return ' <a href="/mapping/' + parseInt(row['id']) + '" class="btn btn-primary btn-xs"><i class="fa fa-eye"></i></a> ' + editButton + deleteButton;
                    },
                    "className": 'text-center',
                    "orderable": false,
                    "data": null,
                },

            ],
            pageLength: 10,
            lengthMenu: [
                [5, 10, 20],
                [5, 10, 20]
            ],
            // Responsive settings
            responsive: true,
            autoWidth: false
        });
    });

    function deleteData(id) {
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: 'btn btn-success',
                cancelButton: 'btn btn-danger'
            },
            buttonsStyling: true
        })
        swalWithBootstrapButtons.fire({
            title: 'Are you sure you want to delete this data?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes',
            cancelButtonText: 'No',
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: 'DELETE',
                    url: '/mapping/' + id,
                    data: {
                        '_token': $('input[name=_token]').val(),
                    },
                    success: function(response) {
                        swalWithBootstrapButtons.fire(
                            'Deleted!',
                            response.message,
                            'success'
                        )
                        $('#list-data').DataTable().ajax.reload();
                    },
                    error: function(xhr, status, error, response) {
                        swalWithBootstrapButtons.fire(
                            'Failed!',
                            'Failed to delete data. Please try again.',
                            'error'
                        )
                    }
                });
            }
        })
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/toyota/resources/views/mapping/index.blade.php ENDPATH**/ ?>