<!DOCTYPE html>
<html>

<?php
$row_data_setting_web = DB::table('setting_web')->orderBy('id', 'desc')->first();
?>

<head>
    <meta charset="utf-8">
    <!-- <meta http-equiv="X-UA-Compatible" content="IE=edge">  -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e($row_data_setting_web->app_alias); ?></title>

    <!-- CSS -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('images/setting/logo.png')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/select2/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/fontawesome-free/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/toastr/toastr.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>">
    <!-- iniditaruh dipaling bawah -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/dist/css/adminlte.min.css')); ?>">
    <style>
        body {
            font-size: 13px; 
        }
    </style>
    <!-- CSS -->

    <!-- JS -->
    <script src="<?php echo e(asset('assets/plugins/jquery/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/dist/js/adminlte.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/jszip/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/pdfmake/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/pdfmake/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatables-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatables-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatables-buttons/js/buttons.colVis.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/jquery-validation/jquery.validate.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/jquery-validation/additional-methods.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/sweetalert2/sweetalert2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/select2/js/select2.full.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/bs-custom-file-input/bs-custom-file-input.min.js')); ?>"></script>

    <!-- JS -->
</head>


<body class="hold-transition sidebar-mini <?php echo e($row_data_setting_web->sidebar_mode); ?> ">
    <div class="wrapper">
        <nav class="main-header navbar navbar-expand <?php echo e($row_data_setting_web->navbar_type); ?> <?php echo e($row_data_setting_web->navbar_color); ?>">
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
                </li>
            </ul>
            <ul class="navbar-nav ml-auto">
                <li class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">
                        <i class="far fa-user-circle"></i>
                        <span class="d-none d-md-inline"><?php echo e(Auth::user()->name); ?></span>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right">
                        <span class="dropdown-item-text"><?php echo e(Auth::user()->name); ?></span>
                        <div class="dropdown-divider"></div>
                        <a href="<?php echo e(url('/home/edit-profile')); ?>" class="dropdown-item">
                            <i class="fas fa-user-cog mr-2"></i> Edit Akun
                        </a>
                        <a class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                            <i class="fas fa-sign-out-alt mr-2"></i> Keluar
                        </a>
                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                            <?php echo csrf_field(); ?>
                        </form>
                    </div>
                </li>
            </ul>

        </nav>
        <aside class="main-sidebar sidebar-<?php echo e($row_data_setting_web->sidebar_type); ?>-danger elevation-4">
            <a href="<?php echo e(url('/home')); ?>" class="brand-link <?php echo e($row_data_setting_web->sidebar_bg2); ?>">
                <img src="<?php echo e(asset('images/setting/'.$row_data_setting_web->app_logo)); ?>" alt="brand Logo" class="brand-image elevation-3" style="opacity: .8">
                <span class="brand-text font-weight-light"> <strong><?php echo e($row_data_setting_web->app_name); ?></strong></span>
            </a>
            <div class="sidebar">
                <?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </aside>
        <div class="content-wrapper"> 
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </div>

    <script>
        $(function() {
            $('.select2').select2();

            //untuk index/list datatable
            $("#idtblharusini").DataTable({
                "responsive": true,
                "lengthChange": true,
                "lengthMenu": [
                    [10, 20, 50, 100, 500, -1],
                    [10, 20, 50, 100, 500, "All"]
                ],
                "autoWidth": false,
                // "buttons": ["copy", "csv", "excel", "pdf", "print"]
            }).buttons().container().appendTo('#idtblharusini_wrapper .col-md-6:eq(0)');

            //untuk modal datatable
            $("#idtblharusini_2").DataTable({
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": []
            }).buttons().container().appendTo('#idtblharusini_2_wrapper .col-md-6:eq(0)');

            //untuk report datatable
            $("#idtblharusini_3").DataTable({
                "scrollX": true,
                "responsive": false,
                "lengthChange": true,
                "lengthMenu": [
                    [10, 20, 50, 100, 500, -1],
                    [10, 20, 50, 100, 500, "All"]
                ],
                "autoWidth": false,
                // "buttons": ["copy", "csv", "excel", "pdf", "print"]
                "buttons": ["copy", "excel", "pdf", "print"]
            }).buttons().container().appendTo('#idtblharusini_3_wrapper .col-md-6:eq(0)');

            $(document).on('keypress', '.hanya_angka', function(e) {
                if (e.which < 48 || e.which > 57) {
                    e.preventDefault();
                }
            });
        });
    </script>

</body>

</html><?php /**PATH /var/www/html/toyota/resources/views/layouts/app.blade.php ENDPATH**/ ?>