<?php $__env->startSection('content'); ?>
<div class="content-header">

    <div class="row">
        <?php if($message = Session::get('success')): ?>
        <div class="col-md-12">
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <?php echo e($message); ?>

            </div>
        </div>
        <?php endif; ?>
        <?php if($message = Session::get('erorr')): ?>
        <div class="col-md-12">
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <?php echo e($message); ?>

            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <span class="card-title"><?php echo e($datas['title']); ?></span>
                </div>
                <div class="card-body">
                    <form method="POST" id="myForm" action="<?php echo e(route('destinations.store')); ?>" role="form" enctype="multipart/form-data">
                        <?php if (isset($data->id)) { ?>
                            <input type="hidden" name="id" value="<?php echo e($data->id); ?>">
                        <?php }  ?>
                        <?php echo csrf_field(); ?>
                        <div class="box box-info padding-1">
                            <div class="box-body row">
                                <div class="form-group col-md-6">
                                    <label for="code">Code<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                    <input type="text" name="code" value="<?php echo e(old('code', $data->code)); ?>" class="form-control<?php echo e($errors->has('code') ? ' is-invalid' : ''); ?>" placeholder="Code" required>
                                    <?php echo $errors->first('code', '<div class="invalid-feedback">:message</div>'); ?>

                                    <span class="text-danger" id="code-error"></span>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="name">Name<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                    <input type="text" name="name" value="<?php echo e(old('name', $data->name)); ?>" class="form-control<?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>" placeholder="Name" required>
                                    <?php echo $errors->first('name', '<div class="invalid-feedback">:message</div>'); ?>

                                    <span class="text-danger" id="name-error"></span>
                                </div>
                            </div>
                            <div class="box-footer mt20">
                                <a class="btn btn-danger" href="<?php echo e(route('destinations.index')); ?>">Back</a>
                                <button type="submit" name="action" value="save_and_close" class="btn bg-primary" id="btnSave">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
    var var_url_store = "<?= $datas['url_store'] ?>";
    var var_url_redirect = "<?= $datas['url_redirect'] ?>";

    document.addEventListener("DOMContentLoaded", function() {
        const myForm = document.getElementById("myForm");
        myForm.addEventListener("submit", function(event) {
            event.preventDefault();

            const btnSave = document.getElementById("btnSave");
            btnSave.innerHTML = "Processing...";
            btnSave.disabled = true;

            Swal.fire({
                title: 'Processing...',
                text: 'Please wait while your data is being saved.',
                allowOutsideClick: false,
                showConfirmButton: false,
                willOpen: () => {
                    Swal.showLoading();
                }
            });
            console.log('urlnya :' + var_url_store);
            $.ajax({
                url: var_url_store,
                type: 'POST',
                dataType: "json",
                encode: true,
                data: $('#myForm').serialize(),
                success: function(response) {
                    // console.log(response);
                    // console.log(response[0]);
                    // return false;
                    if (response[0] == 1003) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success',
                            text: response[1],
                            showConfirmButton: true,
                        }).then(() => {
                            window.location.href = var_url_redirect;
                        });
                    } else {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Warning',
                            text: response[1],
                        });
                    }

                },
                error: function(xhr, status, error) {
                    Swal.close();
                    if (xhr.status === 422) {
                        var validationErrors = xhr.responseJSON.errors;
                        var errorMessages = '';
                        $.each(validationErrors, function(field, messages) {
                            errorMessages += messages[0] + '<br>';
                        });
                        Swal.fire({
                            icon: 'error',
                            title: 'Validation Error',
                            html: errorMessages,
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Failed to save data: ' + (xhr.responseJSON.message || error),
                        });
                    }
                    btnSave.disabled = false;
                    btnSave.innerHTML = "Save";
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/toyota/resources/views/destinations/form.blade.php ENDPATH**/ ?>