<?php $__env->startSection('content'); ?>

<Style>
    .image-preview {
        max-width: 100px;
        max-height: 100px;
        margin-top: 10px;
    }
</Style>
<div class="content-header">
    <div class="row">
        <?php if($message = Session::get('success')): ?>
        <div class="col-md-12">
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <?php echo e($message); ?>

            </div>
        </div>
        <?php endif; ?>
        <?php if($message = Session::get('erorr')): ?>
        <div class="col-md-12">
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <?php echo e($message); ?>

            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<section class="content container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <span class="card-title"><?php echo e($datas['title']); ?></span>
                </div>
                <div class="card-body">
                    <form method="POST" id="myForm" action="<?php echo e(route('mapping.store')); ?>" role="form" enctype="multipart/form-data">
                        <?php if (isset($data->id)) { ?>
                            <input type="hidden" name="id" value="<?php echo e($data->id); ?>">
                        <?php }  ?>
                        <?php echo csrf_field(); ?>
                        <div class="box box-info padding-1">
                            <div class="row">
                                <div class="col-md-6">
                                    <!-- Destination ID Dropdown -->
                                    <div class="form-group">
                                        <label for="destination_id">Destination<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <select name="destination_id" class="form-control<?php echo e($errors->has('destination_id') ? ' is-invalid' : ''); ?> select2" required>
                                            <option value="">Select Destination</option>
                                            <?php $__currentLoopData = $datas['destinations']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $destination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($destination->id); ?>" <?php echo e(old('destination_id', $data->destination_id ?? '') == $destination->id ? 'selected' : ''); ?>><?php echo e($destination->code); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php echo $errors->first('destination_id', '<div class="invalid-feedback">:message</div>'); ?>

                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <!-- Lot Process ID Dropdown -->
                                    <div class="form-group">
                                        <label for="lot_process_id">Lot Process<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <select name="lot_process_id" class="select2 form-control<?php echo e($errors->has('lot_process_id') ? ' is-invalid' : ''); ?> select2" required>
                                            <option value="">Select Lot Process</option>
                                            <?php $__currentLoopData = $datas['lot_processes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lot_process): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($lot_process->id); ?>" <?php echo e(old('lot_process_id', $data->lot_process_id ?? '') == $lot_process->id ? 'selected' : ''); ?>><?php echo e($lot_process->code); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php echo $errors->first('lot_process_id', '<div class="invalid-feedback">:message</div>'); ?>

                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <!-- Case ID Dropdown -->
                                    <div class="form-group">
                                        <label for="case_id">Case<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <select name="case_id" class="form-control<?php echo e($errors->has('case_id') ? ' is-invalid' : ''); ?> select2" required>
                                            <option value="">Select Case</option>
                                            <?php $__currentLoopData = $datas['cases']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($case->id); ?>" <?php echo e(old('case_id', $data->case_id ?? '') == $case->id ? 'selected' : ''); ?>><?php echo e($case->code); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php echo $errors->first('case_id', '<div class="invalid-feedback">:message</div>'); ?>

                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <!--Start Date Field -->
                                    <div class="form-group">
                                        <label for="start_date">Start Date<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <input type="date" name="start_date" class="form-control<?php echo e($errors->has('start_date') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('start_date', $data->start_date ?? '')); ?>" required>
                                        <?php echo $errors->first('start_date', '<div class="invalid-feedback">:message</div>'); ?>

                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <!-- End Date Field -->
                                    <div class="form-group">
                                        <label for="end_date">End Date<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <input type="date" name="end_date" class="form-control<?php echo e($errors->has('end_date') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('end_date', $data->end_date ?? '')); ?>" required>
                                        <?php echo $errors->first('end_date', '<div class="invalid-feedback">:message</div>'); ?>

                                    </div>
                                </div>

                            </div>
                        </div>

                        <!-- Detail Section -->
                        <div class="card card-default">
                            <div class="card-header">
                                <span class="card-title">Mapping Details</span>
                            </div>
                            <div class="card-body">
                                <div id="detail-section">
                                    <!-- Detail Items -->
                                    <div class="detail-item">
                                        <div class="form-group">
                                            <table class="table table-bordered table-mapping-details">
                                                <thead>
                                                    <tr>
                                                        <th colspan="2" style="vertical-align: middle;"> UNIQUE / PART NUMBER</th>
                                                        <th colspan="3">
                                                            <select name="items_id" class="form-control item-dropdown select2">
                                                                <option value="">Select Unique / Part Number</option>
                                                                <?php $__currentLoopData = $datas['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($item->id); ?>">
                                                                    <?php echo e($item->code); ?>

                                                                </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </th>
                                                        <th style="vertical-align: middle;">
                                                            <button type="button" class="btn btn-danger btn-xs" onclick="fetchItemData(this)"><i class="fas fa-plus"></i> Add row</button>
                                                        </th>
                                                    </tr>
                                                    <tr>
                                                        <th width="8%">DELETE</th>
                                                        <th width="2%">SEQUENCE</th>
                                                        <th>UNIQUE NUMBER</th>
                                                        <th>PART NUMBER</th>
                                                        <th>ADDRESS</th>
                                                        <th>IMAGE</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    
                                                    <?php if(isset($data_details)): ?>
                                                    <?php $__currentLoopData = $data_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td class="text-center"><button type="button" class="btn btn-danger remove-row-btn btn-xs"><i class="fas fa-minus"></i></button>
                                                        </td>
                                                        <td>
                                                            <input type="hidden" name="details[<?php echo e($index); ?>][id]" class="form-control" value="<?php echo e($detail->id ?? ''); ?>" required>
                                                            <input type="hidden" name="details[<?php echo e($index); ?>][item_id]" class="form-control" value="<?php echo e($detail->item_id ?? ''); ?>" required>
                                                            <input type="text" name="details[<?php echo e($index); ?>][sequence]" class="form-control c-index hanya_angka" value="<?php echo e($detail->sequence ?? ''); ?>" required>
                                                        </td>
                                                        <td><input type="text" name="details[<?php echo e($index); ?>][code]" class="form-control" value="<?php echo e($detail->code ?? ''); ?>" readonly></td>
                                                        <td><input type="text" name="details[<?php echo e($index); ?>][name]" class="form-control" value="<?php echo e($detail->name ?? ''); ?>" readonly></td>
                                                        <td><input type="text" name="details[<?php echo e($index); ?>][address]" class="form-control" value="<?php echo e($detail->address ?? ''); ?>" readonly></td>
                                                        
                                                        <td>
                                                            <?php if($detail->image): ?>
                                                            <img src="<?php echo e(asset($detail->image)); ?>" class="image-preview" alt="Image Preview">
                                                            <?php endif; ?>
                                                            <input type="file" name="details[<?php echo e($index); ?>][image]" class="form-control" onchange="previewImage(this, <?php echo e($index); ?>)">
                                                            <img id="image-preview-<?php echo e($index); ?>" class="image-preview" src="#" alt="Image Preview" style="display: none;">
                                                        </td>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="box-footer mt20">
                            <a class="btn btn-danger" href="<?php echo e(route('mapping.index')); ?>">Back</a>
                            <button type="submit" name="action" value="save_and_close" class="btn bg-primary" id="btnSave">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
    var var_url_store = "<?= $datas['url_store'] ?>";
    var var_url_redirect = "<?= $datas['url_redirect'] ?>";

    document.addEventListener("DOMContentLoaded", function() {
        const myForm = document.getElementById("myForm");
        myForm.addEventListener("submit", function(event) {
            event.preventDefault();

            const btnSave = document.getElementById("btnSave");
            btnSave.innerHTML = "Processing...";
            btnSave.disabled = true;

            Swal.fire({
                title: 'Processing...',
                text: 'Please wait while your data is being saved.',
                allowOutsideClick: false,
                showConfirmButton: false,
                willOpen: () => {
                    Swal.showLoading();
                }
            });
            console.log('urlnya :' + var_url_store);
            let formData = new FormData(document.getElementById('myForm'));
            $.ajax({
                url: var_url_store,
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                // url: var_url_store,
                // type: 'POST',
                dataType: "json",
                // encode: true,
                // data: $('#myForm').serialize(),
                success: function(response) {
                    // console.log(response);
                    // console.log(response[0]);
                    // return false;
                    if (response[0] == 1003) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success',
                            text: response[1],
                            showConfirmButton: true,
                        }).then(() => {
                            window.location.href = var_url_redirect;
                        });
                    } else {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Warning',
                            text: response[1],
                        });
                    }

                },
                error: function(xhr, status, error) {
                    console.log('ada error');
                    Swal.close();
                    if (xhr.status === 422) {
                        var validationErrors = xhr.responseJSON.errors;
                        var errorMessages = '';
                        $.each(validationErrors, function(field, messages) {
                            errorMessages += messages[0] + '<br>';
                        });
                        Swal.fire({
                            icon: 'error',
                            title: 'Validation Error',
                            html: errorMessages,
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Failed to save data: ' + (xhr.responseJSON.message || error),
                        });
                    }
                },
                complete: function() {
                    btnSave.disabled = false;
                    btnSave.innerHTML = "Save";
                }
            });
        });
    });

    $(document).ready(function() {

        // Function to remove a row
        $(document).on('click', '.remove-row-btn', function() {
            $(this).closest('tr').remove();
        });

        $(document).on('change', '.c-index', function() {
            var rowCount = $('.table-mapping-details tbody tr').length
            this.value = $.trim(this.value.replace(/^0+/, ''));
            for (let idx = 0; idx < rowCount; idx++) {
                // alert($('input[name="details[' + idx + '][sequence]"]').val())
                // alert(this.name)
                // alert(this.value)
                if ((!this.name.includes(idx)) && this.value == $('input[name="details[' + idx + '][sequence]"]').val()) {
                    alert('sequence number is already in use');
                    this.value = '';
                    return false;
                }
            }
        });

        // Function to fetch item data (code and address)
        window.fetchItemData = function() {
            var itemId = $("select[name='items_id']").val();
            var rowCount = $('.table-mapping-details tbody tr').length;
            console.log('itemId : ' + itemId);
            console.log('rowCount : ' + rowCount);
            if (itemId) {
                for (let idx = 0; idx < rowCount; idx++) {
                    // alert(itemId) 
                    // alert($('input[name="details[' + idx + '][item_id]"]').val())
                    if (itemId == $('input[name="details[' + idx + '][item_id]"]').val()) {
                        alert('The part number has already been entered, please choose another one');
                        $("select[name='items_id']").val('').trigger('change')
                        return false;
                    }
                }

                $.ajax({
                    url: '/fetch-item-data/' + itemId,
                    type: 'GET',
                    success: function(response) {
                        if (response && response.id) {
                            console.log('sukses and log');
                            console.log(response);
                            var rowHTML = '<tr>';
                            rowHTML += '<td class="text-center"><button type="button" class="btn btn-danger remove-row-btn btn-xs"><i class="fas fa-minus"></i></button></td>';
                            rowHTML += '<td><input type="text" name="details[' + rowCount + '][sequence]" class="form-control c-index hanya_angka" value="' + (rowCount + 1) + '" required></td>';
                            rowHTML += '<td style="display:none"><input type="text" name="details[' + rowCount + '][item_id]" class="form-control" readonly value="' + response.id + '"></td>';
                            rowHTML += '<td><input type="text" name="details[' + rowCount + '][code]" class="form-control" readonly value="' + response.code + '"></td>';
                            rowHTML += '<td><input type="text" name="details[' + rowCount + '][name]" class="form-control" readonly value="' + response.name + '"></td>';
                            rowHTML += '<td><input type="text" name="details[' + rowCount + '][address]" class="form-control" readonly value="' + response.address + '"></td>';
                            // rowHTML += '<td><input type="file" name="details[' + rowCount + '][image]" class="form-control"></td>';
                            rowHTML += '<td><input type="file" name="details[' + rowCount + '][image]" class="form-control" onchange="previewImage(this, ' + rowCount + ')"><img id="image-preview-' + rowCount + '" class="image-preview" src="#" alt="Image Preview" style="display: none;"></td>';
                            rowHTML += '</tr>';
                            $('.table-mapping-details tbody').append(rowHTML);
                            $("select[name='items_id']").val('').trigger('change')
                        }
                    }
                });
            } else {
                alert('Please select Part Number');
                $("select[name='items_id']").focus();
            }
        };

        window.previewImage = function(input, index) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $('#image-preview-' + index).attr('src', e.target.result).show();
                }

                reader.readAsDataURL(input.files[0]);
            }
        };

    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/toyota/resources/views/mapping/form.blade.php ENDPATH**/ ?>